using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.WebApplication.Accounts
{
    public class Login : BaseComponent
    {
        public Login(Gemini.Core.WebApplication.Interface.IWebPageComponentParam WebPageComponentParam): base(WebPageComponentParam){}

        string _messageError = null;
        string _login_op = null;
        bool _success = false;

        private PI.FM.N005.VariableRepository.BL.VariableRepository _blVariableRepository = null;

        public PI.FM.N005.VariableRepository.BL.VariableRepository BLVariableRepository
        {
            get
            {
                if (_blVariableRepository == null)
                {
                    _blVariableRepository = new PI.FM.N005.VariableRepository.BL.VariableRepository(Environment);
                }
                return _blVariableRepository;
            }
        }

        public override bool Save()
        {
            try
            {
                _login_op = Environment.GetRequestParamString("login_op");
                if ("1".Equals(_login_op))
                {
                    string _login = Environment.GetRequestParamString("login_name");
                    string _password = Environment.GetRequestParamString("login_password");

                    if ((_login != null) && (_password != null))
                    {
                        _success = Environment.Login(_login, _password);
                    }
                }
                else if ("2".Equals(_login_op))
                {
                    _success = Environment.Logout();
                }
                else if ("4".Equals(_login_op))
                {
                    string _login = Environment.GetRequestParamString("login_name");
                    if (_login != null)
                    {
                        _success = BLELearning.SendRemindPasswordEmail(_login);
                    }
                }
            }
            catch (Exception _exeption)
            {
                _messageError = _exeption.Message;
                Gemini.Utility.Debug.SendExeptionViaEmali(Environment.ProjectName,_exeption, String.Format("{0}{1}", Environment.Domain, Environment.URL));
                _success = false;
            }

            return _success;
        }

        public override void Load()
        {
            #region Config
            XML.Element.Start("Config");
            XML.Element.Attribute("IUA", WebPageEngine.IsUserAuthorized ? "1" : "0");
            XML.Element.End();
            #endregion

            XML.Element.Start("LoginOp");
            XML.Element.Attribute("operation", _login_op);
            XML.Element.Attribute("success", _success);
            XML.Element.Attribute("messageError", _messageError);

            string _mainPortalAddress = BLVariableRepository.GetString(BL.Dictionary.Config.AdditionalConfig.MainPortalAddress, BL.Dictionary.Clients.PlugIn, Environment.Domain);
              
            XML.Element.Attribute("mainPortalAddress", _mainPortalAddress);
            XML.Element.End();

            if (WebPageEngine.IsUserAuthorized)
            {
                BL.BO.Student _student = BLELearning.Student.RestoreByUser(Environment.User);
                if (_student != null)
                {
                    XML.Element.Start("User");
                    XML.Element.Attribute("student", 1);
                    XML.Element.Attribute("instructor", 0);
                    XML.Element.Attribute("Email", _student.Email);
                    XML.Element.Attribute("Forename", _student.Forename);
                    XML.Element.Attribute("ID", _student.ID);
                    XML.Element.Attribute("Surename", _student.Surename);
                    XML.Element.Attribute("UserBID", _student.UserID);
                    XML.Element.End();
                }
                else 
                {
                    BL.BO.Instructor _instructor = BLELearning.Instructor.RestoreByUser(Environment.User);
                    if (_instructor != null)
                    {
                        XML.Element.Start("User");
                        XML.Element.Attribute("student", 0);
                        XML.Element.Attribute("instructor", 1);
                        XML.Element.Attribute("Email", _instructor.Email);
                        XML.Element.Attribute("Forename", _instructor.Forename);
                        XML.Element.Attribute("ID", _instructor.ID);
                        XML.Element.Attribute("Surename", _instructor.Surename);
                        XML.Element.Attribute("UserBID", _instructor.UserID);
                        XML.Element.End();
                    }
                }
            }

        }
    }
}